<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
};
?>

<div class="wrap">
    <form method="post" action="options.php" enctype="multipart/form-data" encoding="multipart/form-data">
        <h1>AGF設定</h1>

        <?php
            settings_fields('agfs-custom-setting-group');
            do_settings_sections('agfs-custom-setting-group');
        ?>

        <div class="metabox-holder">
            <div class="postbox ">
                <h3 class='hndle'><span>パスワード</span></h3>
                <div class="inside">
                    <div class="main">
                        <p class="setting_description"></p>
                        <h4>解読用キーを入力してください</h4>
                        <p>
                            <input type="text" id="decrypt_key" name="decrypt_key" value="<?php echo esc_html(sanitize_text_field(get_option('decrypt_key'))); ?>">
                            <div class="">
                                <button class="button button-secondary" id="decrypt_key_generate_btn">キーを生成する</button>
                            </div>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="metabox-holder">
            <div class="postbox ">
                <h3 class='hndle'><span>スタイル設定</span></h3>
                <div class="inside">
                    <div class="main">
                        <label>
                            <input name="css_off" type="checkbox" value="1" <?php checked(1, esc_html(sanitize_text_field(get_option('css_off')))); ?> />CSSを解除する
                        </label>
                    </div>
                </div>
            </div>
        </div>

        <div class="metabox-holder">
            <div class="postbox ">
                <h3 class='hndle'><span>カラー設定</span></h3>
                <div class="inside">
                    <div class="main">
                        <p class="setting_description"></p>
                        <h4>プライマリーカラー</h4>
                        <input
                            name="primary_color"
                            class="color-picker-hex"
                            type="text"
                            id="primary_color"
                            maxlength="7"
                            value="<?php echo (!sanitize_hex_color(get_option('primary_color'))) ? '#0059ff' : esc_html(sanitize_hex_color(get_option('primary_color'))); ?>"
                            placeholder="#0059ff"
                            data-default-color="#0059ff"
                        >
                    </div>
                </div>

                <div class="inside">
                    <div class="main">
                        <p class="setting_description"></p>
                        <h4>ボタンテキストカラー</h4>
                        <input
                            name="btn_text_color"
                            class="color-picker-hex"
                            type="text"
                            id="btn_text_color"
                            maxlength="7"
                            value="<?php echo (!sanitize_hex_color(get_option('btn_text_color'))) ? '#fff' : esc_html(sanitize_hex_color(get_option('btn_text_color'))); ?>"
                            placeholder="#fff"
                            data-default-color="#fff"
                        >
                    </div>
                </div>

                <div class="inside">
                    <div class="main">
                        <p class="setting_description"></p>
                        <h4>テキストカラー</h4>
                        <input
                            name="font_color"
                            class="color-picker-hex"
                            type="text"
                            id="font_color"
                            maxlength="7"
                            value="<?php echo (!sanitize_hex_color(get_option('font_color'))) ? '#333' : esc_html(sanitize_hex_color(get_option('font_color'))); ?>"
                            placeholder="#333"
                            data-default-color="#333"
                        >
                    </div>
                </div>
            </div>
        </div>

        <?php submit_button(); ?>
    </form>

    <!-- <input id="testInput" value="">
    <button id="testBtn">googleフォームセッティングの取得</button> -->

</div>
