import { useBlockProps } from '@wordpress/block-editor';

export default function SaveFieldTemp({attributes, type, htmlDataAttr, children, labelFor}) {
	const {
		prefix,
		property,
		msg,
		label,
		layout,
        isRequired
	} = attributes;

	if(!labelFor) labelFor = `${property}-input`;

    const setting = {
		className: `from__field field-layout -${layout}`,
		[`${prefix}-type`]: type,
	};

	if(isRequired) {
		setting["required"] = true;
	};

	if(htmlDataAttr) {
		Object.assign(setting, htmlDataAttr);
	}

	return (
		<div
			{...useBlockProps.save(setting)}
		>
			<input
				type="hidden"
				name={property}
				value=""
				{...{[`${prefix}-input`]: "true"}}
			/>
			{
				layout == "pattern5"
				?<>
					<div className='field-layout__left'>
						<div className="field-layout__label-area">
							<label className="field-layout__label" htmlFor={labelFor}>{label}</label>
							{
								isRequired && <div className='field-layout__label-required'>必項</div>
							}
						</div>
						{ msg && <div className="field-layout__msg" id={`${property}-describedby`}>{msg}</div>}
					</div>
					<div className='field-layout__right'>
						<div className={`field-layout__input-wrap ${(layout == "pattern3" || layout == "pattern5") ? 'agf-!margin0' : ''}`}>
							{children}
						</div>
						<div {...{[`${prefix}-error`]: "true"}} className="field-layout__error" role="alert"></div>
					</div>
				</>
                :<>
					<div className="field-layout__label-area">
						<label className="field-layout__label" htmlFor={labelFor}>{label}</label>
						{
							isRequired && <div className='field-layout__label-required'>必項</div>
						}
					</div>
					{ msg && <div className={`field-layout__msg ${(layout == "pattern1" || layout == "pattern4") ? 'agf-!margin0' : ''}`} id={`${property}-describedby`}>{msg}</div>}
					<div className={`field-layout__input-wrap ${(layout == "pattern3" || layout == "pattern5") ? 'agf-!margin0' : ''}`}>
						{children}
					</div>
					<div {...{[`${prefix}-error`]: "true"}} className="field-layout__error" role="alert"></div>
				</>
			}
		</div>
	)
};