import {
	PanelBody,
	Button
} from '@wordpress/components';
import {
	RichText
} from '@wordpress/block-editor';


import { DragDropContext, Droppable, Draggable } from "react-beautiful-dnd";


export default function OptionsController({ options, setAttributesHasKey }) {
    const optionsOnChangeEvent = (att, val, index) => {
		const newData = JSON.parse(JSON.stringify(options))
		newData[index][att] = val
		setAttributesHasKey(newData)
    }

    const addOptions = () => {
		const newData = JSON.parse(JSON.stringify(options))
		newData.push({
			label: "",
			value: ""
		})
		setAttributesHasKey(newData)
    }

    const deleteOptions = (index) => {
        const newData = JSON.parse(JSON.stringify(options))
        newData.splice(index, 1);
        setAttributesHasKey(newData)
    }

    if(options.length <= 0) {
		addOptions()
	}


    const reorder = (list, startIndex, endIndex) => {
        const result = Array.from(list);
        const [removed] = result.splice(startIndex, 1);
        result.splice(endIndex, 0, removed);
        return result;
    };

    const onDragEnd = (result) => {
        // dropped outside the list
        if (!result.destination) {
          return;
        }

        const items = reorder(
            options,
            result.source.index,
            result.destination.index
        );

        setAttributesHasKey(items);
    }

  const grid = 8;

  const getItemStyle = (isDragging, draggableStyle) => ({
    // some basic styles to make the items look a bit nicer
    userSelect: "none",
    padding: "6px 8px",
    margin: `0 0 ${grid}px 0`,
    display: 'flex',
    gap: '2px',
    alignItems: 'center',

    // change background colour if dragging
    background: isDragging ? "gary" : "#fff",

    // styles we need to apply on draggables
    ...draggableStyle
  });

  const getListStyle = isDraggingOver => ({
    background: isDraggingOver ? "lightblue" : "#fff",
    padding: 0,
  });

    return(
        <div className='drag-drop-items'>
            <DragDropContext onDragEnd={onDragEnd}>
                <Droppable droppableId="droppable">
                    {(provided, snapshot) => (
                        <div
                            {...provided.droppableProps}
                            ref={provided.innerRef}
                            style={getListStyle(snapshot.isDraggingOver)}
                        >
                            {
                                options.map((item, index) => {
                                    return(
                                        <Draggable key={`key-${index}`} draggableId={`id-${index}`} index={index}>
                                            {(provided, snapshot) => (
                                                <div
                                                    ref={provided.innerRef}
                                                    {...provided.draggableProps}
                                                    style={getItemStyle(
                                                        snapshot.isDragging,
                                                        provided.draggableProps.style
                                                    )}
                                                >
                                                    <div class="dragHandle" {...provided.dragHandleProps}></div>
                                                    <RichText
                                                        tagName="div"
                                                        value={item.label}
                                                        onChange={ ((value) => optionsOnChangeEvent('label', value, index)) }
                                                        placeholder="label"
                                                        className="options-controller-filed__key"
                                                    />
                                                    :
                                                    <RichText
                                                        tagName="div"
                                                        value={item.value}
                                                        onChange={ ((value) => optionsOnChangeEvent('value', value, index)) }
                                                        placeholder="value"
                                                        className="options-controller-filed__value"
                                                    />
                                                    <button
                                                        className="options-controller-filed__delete"
                                                        onClick={(() => deleteOptions(index))}
                                                    >消</button>
                                                </div>
                                            )}
                                        </Draggable>
                                    )
                                })
                            }
                            {provided.placeholder}
                        </div>
                    )}
                </Droppable>
            </DragDropContext>
            <div className='u-flex -x-center'>
                <Button
                    variant="primary"
                    onClick={addOptions}
                >選択肢を追加</Button>
            </div>
            <div className='u-mt-16'></div>
        </div>
    )
}