import {
	PanelBody,
	SelectControl,
	__experimentalText as Text,
} from '@wordpress/components';

export default function FiledConnecter({ contextProperties, property, onChangeEvent }) {
    return(
        <PanelBody title={'googleフォームフィールドデータ'}>
            {
                (!contextProperties?.labels)
                ? <Text>連携フィールドが見つかりません</Text>
                : <SelectControl
                    label="連携フィールドを選択"
                    value={property}
                    options={[{
                        "label": "選択してください",
                        "value": ""
                    }, ...contextProperties.labels.map(item => {
                        return {
                            "label": item.label,
                            "value": item.id
                        }
                    })]}
                    onChange={ ((value) => onChangeEvent('property', value)) }
                />
            }
        </PanelBody>
    )
};