
import {
	RichText,
} from '@wordpress/block-editor';

export default function FieldTemp({ useBlockProps, attributes, onChangeEvent, children }) {
	const {
		label,
		msg,
		layout,
        isRequired
	} = attributes;

    return (
        <div {...useBlockProps({className: `field-layout -${layout}`})}>
            {
                layout == "pattern5"
                ?<div className="field-layout__label-area">
                    <div>
                        <div className="field-layout__label agf-flex -gap12 -y-start">
                            <RichText
                                tagName="div"
                                value={label}
                                onChange={ ((value) => onChangeEvent('label', value)) }
                                placeholder="ラベル"
                            />
                            {
                                isRequired && <div className='field-layout__label-required'>必項</div>
                            }
                        </div>
                        <RichText
                            tagName="div"
                            value={msg}
                            onChange={ ((value) => onChangeEvent('msg', value)) }
                            placeholder={'補足テキストを入力'}
                            className="field-layout__msg"
                        />
                    </div>
                </div>
                :<>
                    <div className={`field-layout__label-area`}>
                        <RichText
                            tagName="div"
                            value={label}
                            onChange={ ((value) => onChangeEvent('label', value)) }
                            placeholder="ラベル"
                            className="field-layout__label"
                        />
                        {
                            isRequired && <div className='field-layout__label-required'>必項</div>
                        }
                    </div>
                    <RichText
                        tagName="div"
                        value={msg}
                        onChange={ ((value) => onChangeEvent('msg', value)) }
                        placeholder={'補足テキストを入力'}
                        className={`field-layout__msg ${(layout == "pattern1" || layout == "pattern4") ? 'agf-!margin0' : ''}`}
                    />
                </>
            }
            <div className={`field-layout__input-wrap ${(layout == "pattern3" || layout == "pattern5") ? 'agf-!margin0' : ''}`}>{children}</div>
            <div className="field-layout__error">こちらにエラー内容が表示されます</div>
        </div>
    )
};