
/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { InnerBlocks, useBlockProps } from '@wordpress/block-editor';

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
export default function save({attributes}) {
	const { actionUrl, prefix, properties, thanksPageUrl } = attributes;

	return (
		<>
			<form
				{ ...useBlockProps.save({
					className: "agf-form js-agf-form"
				})}
				action={properties["formActionUel"]}
				prefix={prefix}
				target={`${prefix}_iframe`}
				thanksPageUrl={thanksPageUrl}
				method="POST"
			>
				{/* <div className="agf-form__counter">
					<div className="agf-form__counter-label">残り入力数</div>
					<div className="agf-form__counter-num" {...{[`${prefix}-counter`]: "true"}}></div>
				</div> */}
				<div className="agf-form__main">
					<InnerBlocks.Content />
				</div>
			</form>
		</>
	);
}
