/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { useBlockProps } from '@wordpress/block-editor';

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
export default function save({attributes}) {
	const {
		prefix,
		label,
		isDummy,
		honeySpotMsg
	} = attributes;

	return (
		<div {...useBlockProps.save()}>
			{
				isDummy && <div className='agf-flex -x-center' {...{[`${prefix}-type`]:"required"}}>
							<input type="hidden" name="required_send" value="" {...{[`${prefix}-input`]:"true"}} />
							<div className='agf-checkbox'>
								<input className='agf-checkbox__input' type="checkbox" value="" name={`${prefix}-required`} id={`${prefix}-required`} {...{[`${prefix}-item`]:"true"}}/>
								<label className='agf-checkbox__label' htmlFor={`${prefix}-required`}>{(honeySpotMsg) ? honeySpotMsg : "あなたが人間の場合、こちらにチェックを入れないでください。"}</label>
								<div {...{[`${prefix}-error`]: "true"}} className="field-layout__error -center" role="alert"></div>
							</div>
						</div>
			}
			<div className='agf-flex -x-center agf-mt-16' {...{[`${prefix}-type`]:"submit"}}>
				<a href="" className='agf-submit-btn -disabled' {...{[`${prefix}-submit`]:"submit"}} disabled={true}>
					<span className='agf-submit-btn__label'>{(label) ? label : '送信'}</span>
					<span className='agf-submit-btn__loading'></span>
				</a>
			</div>
		</div>
	);
}
