/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { useBlockProps } from '@wordpress/block-editor';

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
export default function save({attributes}) {
	const {
		sp,
		dt
	} = attributes;

	const spClassSet = [
		"-space-s-1",
		"-space-s-2",
		"-space-s-4",
		"-space-s-8",
		"-space-s-16",
		"-space-s-32",
		"-space-s-64"
	]

	const dtClassSet = [
		"-space-d-1",
		"-space-d-2",
		"-space-d-4",
		"-space-d-8",
		"-space-d-16",
		"-space-d-32",
		"-space-d-64"
	]

	/**
	 * 10進数を2進数へ変換
	 */
	const parseBinary = (num) => {
		return Number(num).toString(2);
	}

	/**
	 * 2進数を10進数へ変換
	 */
	const parseDecimal = (decimal) => {
		return parseInt(String(decimal), 2)
	}


	const getClass = (num, device) => {
		const binary = parseBinary(num);
		console.log("binary", binary);
		const binaryArray = binary.split('');
		console.log("binaryArray", binaryArray);
		const classList = [];
		binaryArray.reverse().forEach((item, index) => {
			console.log("item", item);
			if(item == 1) {
				if(device == "sp") classList.push(spClassSet[index]);
				if(device == "dt") classList.push(dtClassSet[index]);
			}
		})

		return classList.join(' ');
	}

	return (
		<div { ...useBlockProps.save({
			className: `agf-space ${getClass(dt, 'dt')} ${getClass(sp, 'sp')}`
		}) }></div>
	);
}
