/**
 * Retrieves the translation of text.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-i18n/
 */
import { __ } from '@wordpress/i18n';

/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import {
	PanelBody,
	TextControl
} from '@wordpress/components';
import {
	useBlockProps,
	InspectorControls
} from '@wordpress/block-editor';

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * Those files can contain any CSS code that gets applied to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */
import './editor.scss';

/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @return {Element} Element to render.
 */
export default function Edit({ attributes, setAttributes }) {
	const {
		sp,
		dt
	} = attributes;

	/**
	 * 値を保存
	 * @param {string} att - 保存対象のkey
	 * @param {any} val - 保存対象のvalue
	 * @returns void
	 */
	const onChangeEvent = ( att, val ) => {
		setAttributes( { [att]: val } )
	};

	const classSet = [
		"-space-d-1",
		"-space-d-2",
		"-space-d-4",
		"-space-d-8",
		"-space-d-16",
		"-space-d-32",
		"-space-d-64"
	]

	/**
	 * 10進数を2進数へ変換
	 */
	const parseBinary = (num) => {
		return Number(num).toString(2);
	}

	/**
	 * 2進数を10進数へ変換
	 */
	const parseDecimal = (decimal) => {
		return parseInt(String(decimal), 2)
	}


	const getClass = (num) => {
		const binary = parseBinary(num);
		console.log("binary", binary);
		const binaryArray = binary.split('');
		console.log("binaryArray", binaryArray);
		const classList = [];
		binaryArray.reverse().forEach((item, index) => {
			console.log("item", item);
			if(item == 1) {
				classList.push(classSet[index]);
			}
		})

		return classList.join(' ');
	}

	const blockProps = useBlockProps({
		className: `u-d-space ${getClass(dt)}`
	})

	return (
		<>
			<InspectorControls>
				<PanelBody title={'余白設定'}>
					<TextControl
						label="デスクトップ時の余白（px）"
						value={dt}
						onChange={ ((value) => onChangeEvent('dt', value)) }
					/>
					<TextControl
						label="スマホ時の予約(px)"
						value={sp}
						onChange={ ((value) => onChangeEvent('sp', value)) }
					/>
				</PanelBody>
			</InspectorControls>
			<div {...blockProps}></div>
		</>
	);
}
