/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { useBlockProps } from '@wordpress/block-editor';


import SaveFieldTemp from '../../components/SaveFieldTemp';

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
export default function save({attributes}) {
	const {
		prefix,
		selectBoxOptions,
		state,
		stateId,
		isRequired,
		property
	} = attributes;


	const labelFor = `${property}-input`;
	const describedby = `${property}-describedby`;

	const attr = {
		'aria-describedby' : describedby,
		'id': labelFor
	};

	if(state) attr["state"] = stateId

	const inputAttr = {[`${prefix}-item`]: "true"};

	if(isRequired) {
		inputAttr["required"] = true;
		inputAttr["aria-required"] = "true";
	};


	return (
		<SaveFieldTemp
			attributes={attributes}
			htmlDataAttr={attr}
			type="select"
			labelFor={labelFor}
		>
			<select
				className="text-input field-layout__input-select"
				{...inputAttr}
			>
				{
					selectBoxOptions.map(item => (
						<option value={item.value}>{item.label}</option>
					))
				}
			</select>
		</SaveFieldTemp>
	);
}
