/**
* 値の変更を監視します
* @param {Object} obj 監視対象のオブジェクト
* @param {String} propName 監視対象のプロパティ名
* @param {function(Object, Object)} func 値が変更された際に実行する関数
*/
export default function watcher(obj, propName, func) {
   let value = obj[propName];
   Object.defineProperty(obj, propName, {
       get: () => value,
       set: newValue => {
           const oldValue = value;
           value = newValue;
           func(oldValue, newValue);
       },
       configurable: true
   });
}