import Debugger from "./Debugger.js";
import InputEl from "./InputEl.js";
import watcher from "./watchValue.js";

import beforeunload from "./Beforeunload.js";

export default class EFOForm {
    form; // {HtmlElement} フォーム全体のエレメント
    prefix; // {string} データ属性のプレフィックス
    fieldDataSet = []; // {InputEl[]} フォームのデータセット
    counterDisplay = []; // {NodeList[]} 残り必項入力フォーム数を表示するエレメント
    requiredFieldNum = 0; // {number} 入力必項フィールドの数
    urlParam = []; // urlのパラメータ
    submitBtns; // 送信ボタンのアイテムリスト
    isSent = false; // 送信済みステータス

    constructor(props = {}) {
        this.form = props?.form;
        this.prefix = props?.prefix;
    }

    init() {
        Debugger.log("EFOForm init");

        // デフォルトバリューセット
        const urlString = window.location.href;
        this.urlParam = new URL(urlString).searchParams;

        const fields = this.form.querySelectorAll(`[${this.prefix}-type]`);
        this.counterDisplay = this.form.querySelectorAll(`[${this.prefix}-counter]`);
        this.progressBar = this.form.querySelectorAll(`[${this.prefix}-progress-bar]`);
        this.submitBtns = (this.form.querySelectorAll(`[${this.prefix}-submit]`).length >= 1)
        ? this.form.querySelectorAll(`[${this.prefix}-submit]`)
        : this.form.querySelectorAll(`.${this.prefix}-submit`)

        if(this.submitBtns.length >= 1) {
            Debugger.log("set btn event");
            this.submitBtns.forEach((btn) => {
                btn.addEventListener("click", this.submitClickEvent.bind(this));
            });
        }

        fields.forEach((field) => {

            const dataSet = this._getFormDataFormat();

            const type = field.getAttribute(`${this.prefix}-type`);

            if(type == "submit") return;

            const el = (type == "radio" || type == "checkbox") ? field.querySelectorAll(`[${this.prefix}-item]`) : field.querySelector(`[${this.prefix}-item]`);
            const elForSend = (field.querySelector(`[${this.prefix}-input]`))
                                ? field.querySelector(`[${this.prefix}-input]`)
                                : field.querySelector(`.${this.prefix}-input`);
            const elForMsg = field.querySelector(`[${this.prefix}-error]`);
            const filedName = elForSend.getAttribute(`name`);

            if(type == "required") dataSet.check.status = true;

            dataSet.type = type;
            dataSet.el = el;
            dataSet.elForSend = elForSend;
            dataSet.elForMsg = elForMsg;
            dataSet.filedName = filedName;

            field.addEventListener('click', () => beforeunload.on());

            Object.keys(dataSet.options).forEach((key) => {
                if(!field.hasAttribute(key)) return;
                if(["state", "zip", "address", "maxlength"].indexOf(key) === -1) {
                    // 含まれていない場合
                    dataSet.options[key] = true;
                } else {
                    dataSet.options[key] = field.getAttribute(key);
                }
            })

            this.fieldDataSet.push(new InputEl(dataSet))
        }); // ebd fields.forEach

        this.countRequiredField();
    }

    _getFormDataFormat() {
        return { // フォームデータセットのフォーマット
            filedName: "", // フィールド名（送信用inputに記載のname属性の値）
            el: null, // 入力用inputのエレメント
            elForSend: null, // 送信用inputのエレメント
            elForMsg: null, // バリデーションメッセージ用のエレメント
            type: null, // 入力タイプ
            value: null, // 有力された値
            check: { // バリデーションチェック
                status: false,
                msg: null
            },
            options: {
                required: false, // true必項バリデーションがかかる - boolean
                state:false, // 都道府県セレクトボックス
                address:false, // 住所連携のidを記載（郵便番号idと同じにする事で郵便番号から自動的に住所を割り出し、自動入力します） - string
                email:false, // trueでemailバリデーションがかかる - boolean
                phone:false, // trueで電話番号バリデーションがかかる - boolean
                multiple:false, // 未使用
                price:false, //trueで金額入力になります（数字を入力すると3桁ごとにカンマ区切りになる）  - boolean
                z2h:false, // trueで全角を半角に変換します - boolean
                h2z:false, // trueで半角を全角に変換します - boolean
                zip:false, // tueで郵便番号から自動で住所を割り出します。データの値をaddress, stateとそろえる事で自動入力の連携を行います - boolean
                maxlength: false // 入力文字数のマックス値（半角を1文字、全角を2文字としてカウントします）
            }
        }
    }

    getFormDataSet() {
        return this.fieldDataSet;
    }

    start() {
        this.fieldDataSet.forEach((field, filedIndex) => {
            field.start();
            const func = function(oldValue, newValue) {
                this.valueChangeEvent(field, oldValue, newValue);
            };
            watcher(field.getData().check, "status", func.bind(this));

            this.urlParam.forEach((value, key) => {
                if(field.getData().filedName == key) {
                    field.setDefaultValue(value);
                    field.check();
                }
            });
        })

        this.renderCounter();
        this.submitStatusEvent();
    }

    /**
     * 値の変化があった場合の処理
     * @param {InputEl} field InputElインスタンス
     * @param {any} oldValue 変更前の値
     * @param {any} newValue 変更後の値
     */
    valueChangeEvent(field, oldValue, newValue) {
        Debugger.log("valueChangeEvent")
        Debugger.log(field.getData());

        if(field.getData().options.zip && newValue && oldValue != newValue) {
            Debugger.log("zip change");
            this.setAddress(field);
        }

        this.renderCounter();
        this.submitStatusEvent();
    }

    /**
     * 現在のセクション（ステップ）に存在するすべてのフィールドのバリデーションチェックがtrueかどうかをチェックします
     * @returns {boolean}
     */
    validationStatusCheck() {
        let status = true;
        this.fieldDataSet.forEach((field) => {
            Debugger.log("check => " + field.getData().check.status);
            if(!field.getData().check.status) status = false;
        })
        return status;
    }

    /**
     * フォームの入力状況を表示
     */
    renderCounter() {
        Debugger.log("renderCounter");
        this.counterDisplay.forEach((el) => {
            el.innerHTML = `${this.countNotCompField()}/${this.requiredFieldNum}`;
        })
    }

    /**
     * 必項フィールドでバリデーションチェックがfalseなフィールドの数を数える
     * @return {number} falseフィールドの数
     */
    countNotCompField() {
        let counter = 0;
        this.fieldDataSet.forEach((field) => {
            if(field.getData().options.required && !field.getData().check.status) counter++;
        });
        return counter;
    }


    /**
     * 必項フィールドの数を数える
     * @return {number} 必項フィールドの数
     */
    countRequiredField() {
        let counter = 0;
        this.fieldDataSet.forEach((field) => {
            if(field.getData().options.required) counter++;
        })
        this.requiredFieldNum = counter;
        return counter;
    }

    /**
     * ハニースポットチェック
     */
    honeySpotCheck() {
        let counter = 0;
        this.fieldDataSet.forEach((field) => {
            if(field.getData().type == "required" && !field.getData().check.status) counter++;
        });
        return counter;
    }


    /**
     * 住所情報をセット
     */
    setAddress(field) {
        Debugger.log("setAddress");
        const address = field.getData().address;
        const id = field.getData().options.zip;
        if(id && address) {
            this.fieldDataSet.forEach((_field) => {
                if(_field.getData().options.state == id && _field.getData().el.value == "") {
                    Debugger.log("set state");
                    _field.getData().el.value = address.address1;
                    _field.getData().elForSend.value = address.address1;
                    _field.check();
                    _field.renderMsg();
                } else if(_field.getData().options.address == id && _field.getData().el.value == "") {
                    Debugger.log("set address");
                    _field.getData().el.value = `${address.address1} ${address.address2}`;
                    _field.getData().elForSend.value = `${address.address1} ${address.address2}`;
                    _field.check();
                    _field.renderMsg();
                }
            });
        }
    }


    /**
     * 送信ボタンのdisabledをコントロール
     */
    submitStatusEvent() {
        Debugger.log("submitStatusEvent");
        if(this.countNotCompField() <= 0  && this.honeySpotCheck() <= 0) {
            this.submitBtns.forEach((item) => {
                item.disabled = false;
                item.classList.add("-active");
                item.classList.remove("-disabled");
                item.style.pointerEvent = true;
            });
        } else {
            this.submitBtns.forEach((item) => {
                item.disabled = true;
                item.classList.remove("-active");
                item.classList.add("-disabled");
                item.style.pointerEvent = false;
            });
        }
    }

    submitClickEvent(e) {
        e.preventDefault();
        if(!this.isSent && this.countNotCompField() <= 0 && this.honeySpotCheck() <= 0) {
            Debugger.log("submitClickEvent");
            beforeunload.off();
            // e.preventDefault();
            // Debugger.log(e);
            // const event = new CustomEvent(`${this.prefix}FormSubmit`, {
            //     detail: this.form
            // });
            // dispatchEvent(event);
            // 上のコードを https://obfuscator.io/ で難読化している
            const _0xa20f75=_0x5ada;(function(_0x1c6771,_0x3fc385){const _0x530f96=_0x5ada,_0x3bb6df=_0x1c6771();while(!![]){try{const _0x29213f=parseInt(_0x530f96(0x14f))/0x1+parseInt(_0x530f96(0x14c))/0x2*(parseInt(_0x530f96(0x14a))/0x3)+parseInt(_0x530f96(0x148))/0x4*(-parseInt(_0x530f96(0x14d))/0x5)+-parseInt(_0x530f96(0x152))/0x6*(parseInt(_0x530f96(0x151))/0x7)+parseInt(_0x530f96(0x154))/0x8+-parseInt(_0x530f96(0x150))/0x9+parseInt(_0x530f96(0x149))/0xa;if(_0x29213f===_0x3fc385)break;else _0x3bb6df['push'](_0x3bb6df['shift']());}catch(_0x33de12){_0x3bb6df['push'](_0x3bb6df['shift']());}}}(_0x3a23,0x3c508),e[_0xa20f75(0x14e)](),Debugger[_0xa20f75(0x14b)](e));const event=new CustomEvent(this[_0xa20f75(0x153)]+_0xa20f75(0x146),{'detail':this[_0xa20f75(0x147)]});dispatchEvent(event);function _0x5ada(_0x59ca12,_0x414bdc){const _0x3a2354=_0x3a23();return _0x5ada=function(_0x5ada14,_0x3254fd){_0x5ada14=_0x5ada14-0x146;let _0x5f1fea=_0x3a2354[_0x5ada14];return _0x5f1fea;},_0x5ada(_0x59ca12,_0x414bdc);}function _0x3a23(){const _0x2a740a=['1460515VvwihR','preventDefault','187222nTSMHH','979902JQpibv','33509olILCS','228gZazwC','prefix','3502512HrXZII','FormSubmit','form','4xVKgUC','93010axETww','293397ZqEkgC','log','4roKYra'];_0x3a23=function(){return _0x2a740a;};return _0x3a23();}
            this.isSent = true;
            this.submitBtns.forEach((btnEl) => {
                btnEl.classList.add("-loading");
            })
        }
    }
}