let instance;
let flag = false;

class Beforeunload {

    constructor() {
        if (instance) {
            return instance;
        }

        instance = this;
        this.#init();
    }

    #init() {
        window.addEventListener('beforeunload', (e) => {
            if(!flag) return;
            e.preventDefault();
            e.returnValue = '';
            return;
        })
    }

    on() {
        flag = true;
    }

    off() {
        flag = false;
    }
}


const beforeunload =  Object.freeze(new Beforeunload());
export default beforeunload;