import Debugger from "./Debugger.js";

export default class AutoSetZip {
    endPoint = "https://zipcloud.ibsnet.co.jp/api/search";
    addressData = {};

    constructor(props = {}) {
        this.el = props?.el;
        this.stateEl = props?.stateEl;
        this.stateElForSend = props?.stateElForSend;
        this.addressEl = props?.addressEl;
        this.addressElForSend = props?.addressElForSend;
    }

    async search(zipcode) {
        if(!zipcode) return;

        try {
            const response = await fetch(`${this.endPoint}?zipcode=${zipcode}`);

            const data = await response.json();
            if (!response.ok) {
                Debugger.error("response error")
                Debugger.error(data);
                throw new Error(data);
            }
            Debugger.log("success");
            Debugger.log(data);
            this.addressData = data.results[0];
            return this;
        } catch (error) {
            Debugger.error("catch error");
            Debugger.error(error);
        }
    }

    getData() {
        return this.addressData;
    }


    setData() {
        if(this.stateEl instanceof HTMLElement) {
            this.stateEl.value = `${this.addressData.address1}`;
        }

        if(this.stateElForSend instanceof HTMLElement) {
            this.stateElForSend.value = `${this.addressData.address1}`;
        }

        if(this.addressEl instanceof HTMLElement) {
            this.addressEl.value = `${this.addressData.address2} ${this.addressData.address3}`;
        }

        if(this.addressElForSend instanceof HTMLElement) {
            this.addressElForSend.value = `${this.addressData.address2} ${this.addressData.address3}`;
        }
    }
}