<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/reference/functions/register_block_type/
 */
function advancedgforms_block_init() {
	// wp_set_script_translations( 'advancedgforms-script', 'advancedgforms', plugin_dir_path( __FILE__ ) . 'languages' );

	$blocks = [
		"form-wrap",
		"form-space",
		"form-text",
		"form-textarea",
		"form-checkbox",
		"form-radio",
		"form-selectbox",
		"form-submit"
	];

	foreach ($blocks as $block) {
		register_block_type(
			AGFS_PLUGIN_PATH . '/build/blocks/' . $block,
		);
	};
}
add_action( 'init', 'advancedgforms_block_init' );