<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use DiDom\Document;

class AGFS_Wp_Json_Setting {
    /**
	 * @return WpJsonSetting
	 */
	public function __construct() {

		// Activate hooks
		$this->activate_actions();
		$this->activate_filters();
	}

    /**
	 * Register listeners for actions
	 *
	 * @return void
	 */
	private function activate_actions() {
        add_action( 'rest_api_init', array( $this, 'settings_google_from' ) );
    }

    /**
	 * Register listeners for filters
	 *
	 * @return void
	 */
	private function activate_filters() {}


    /**
     * googleフォームから入力フィールドの値を取得する
     *  @return void
     */
    public function settings_google_from() {
        $post_args = array(
            'url'  =>  array(
              'type'     => 'string',
              'required' => true,
            )
        );
        register_rest_route(
            'agfs/v1',
            '/googleFormSetting',
            array(
                array(
                    'methods'             => 'POST',
                    'callback'            => array($this, 'get_settings_google_from_event_v2'),
                    'permission_callback' => array($this, 'api_permission'),
                    'args'                => $post_args
                )
            )
        );
    }
    
    /**
     * googleフォームから入力フィールドの値を取得する DiDom varsion
     * @return WP_REST_Response
     */
    public function get_settings_google_from_event_v2($request) {
        $data = $request->get_params();

        $url_pattern = '/^https:\/\/docs\.google\.com\/forms.+/';

        if(!preg_match( $url_pattern, $data["url"])) {
            $response = new WP_REST_Response("params error");
            $response->set_status(402);
            return $response;
        };

        $data["url"] = sanitize_url($data["url"]);

        if($html = @file_get_contents($data["url"])) {

            $dom = new Document();
            $dom->loadHtml($html);

            $res = array();

            $forms = $dom->find("form");
            $res["form_action_uel"] = $forms[0]->attr('action');

            $labels = array();

            foreach($dom->find("[data-params]") as $element) {
                $params = $element->attr("data-params");
                $split_data = explode(",", $params);
                $id = preg_replace('/[^0-9]/', '', $split_data[4]);
                $label = $split_data[1];
                array_push($labels, array(
                    "label" => $label,
                    "id" => "entry.".$id
                ));
            }

            $res["labels"] = $labels;

            $response = new WP_REST_Response($res);
            $response->set_status(200);
            return $response;
        } else {
            $response = new WP_REST_Response("file_get_contents error");
            $response->set_status(402);
            return $response;
        }
    }


    /**
     * wp rest api の権限設定
     */
    public function api_permission($request) {
        // 権限の参考 https://elearn.jp/wpman/column/c20110414_01.html
        return current_user_can('edit_users');
    }
}