<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
};

function agfrandomkey($length = 8)
{
    return substr(str_shuffle('1234567890abcdefghijklmnopqrstuvwxyz'), 0, $length);
}

define('AGFS_VERSION', '1.0.0');
define('AGFS_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('AGFS_DECRYPT_KEY', empty(get_option('decrypt_key')) ? agfrandomkey() : esc_html(get_option('decrypt_key')));
define('AGFS_CSS_OFF', esc_html(get_option('css_off')));
define('AGFS_SCRIPT_PATH', plugins_url('assets/js/agf.js', __FILE__));
define('AGFS_CRYPTO_PATH', plugins_url('assets/js/crypto-js.min.js', __FILE__));
define('AGFS_FORM_CSS_PATH', plugins_url('assets/css/agf-form-style.css', __FILE__));
define('AGFS_UTILITY_CSS_PATH', plugins_url('assets/css/agf-utility-style.css', __FILE__));
define('AGFS_PRIMARY_COLOR', empty(get_option('primary_color')) ? "#0059ff" : esc_html(get_option('primary_color')));
define('AGFS_BTN_TEXT_COLOR', empty(get_option('btn_text_color')) ? "#fff" : esc_html(get_option('btn_text_color')));
define('AGFS_FRONT_COLOR', empty(get_option('font_color')) ? "#333" : esc_html(get_option('font_color')));